package userinterface;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

/**
 * 
 * @author OUZEGGANE Redouane
 *<br/><br/>Pour créer une fenêtre Swing, on cree une classe qui herite de JFrame
 *On ajouter apres ce qui est specifique a notre fenetre
 *Comme les trois boutons, une et une seule instanciation (singleton)
 */
public class MyFrame extends JFrame{
	private static final long serialVersionUID = 1L;
	
	private static JFrame instance = null; // l'unique instance a creer (singleton)
	
	private JButton	bRouge;
	private JButton	bBlanc;
	private JButton	bVert;
	
	/**
	 * Constructeur private : interdiction d'instancier en dehors de la classe
	 */
	private MyFrame(){
		super("Mon premier example avec JFrame");
		initContents();
	}
	
	/**
	 * Pour initialiser le contenu de la fenetre
	 */
	private void initContents(){
		this.bRouge = new JButton("Rouge");
		this.bBlanc = new JButton("Blanc");
		this.bVert = new JButton("Vert");
		
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setResizable(false);
		
		manageLyaout();
		manageEvents();
	}
	
	/**
	 * Pour gerer la disposition des composants graphiques (3 boutons) sur le frame
	 */
	private void manageLyaout(){
		this.setLayout(null); // Aucun gestionnaire de disposition : disposition manuelle
		
		bRouge.setBounds(50, 100, 100, 25); // setBounds (x, y, width, height)
		bBlanc.setBounds(200, 100, 100, 25);
		bVert.setBounds(350, 100, 100, 25);
		
		this.add(bRouge);
		this.add(bBlanc);
		this.add(bVert);
		
		this.setSize(500, 225);
		this.setLocationRelativeTo(null);
	}
	
	/**
	 * Pour programmer les differents evenments
	 */
	private void manageEvents(){
		//Implémenter puis instancier l'interface ActionListener
		ActionListener actionListenerAllButtons = new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				handleActionEvents(evt);
			}
		};
		
		// Assicier le même traitement aux trois boutons
		bRouge.addActionListener(actionListenerAllButtons);
		bBlanc.addActionListener(actionListenerAllButtons);
		bVert.addActionListener(actionListenerAllButtons);
	}
	
	/**
	 * le traitement de l'evenement ActionEvent<br/>
	 * @param evt : l'evenement capte par l'application
	 */
	private void handleActionEvents(ActionEvent evt){
		Color color = this.getContentPane().getBackground();
		if (evt.getSource().equals(bRouge)){
			color = Color.RED;
		}
		else if (evt.getSource().equals(bBlanc)){
			color = Color.WHITE;
		}
		else if (evt.getSource().equals(bVert)){
			color = Color.GREEN;
		}
		
		this.getContentPane().setBackground(color);
	}
	
	/**
	 * permet de creer une instance (si elle n'est pas deja creee) et l'affiche avec setVisible(true)
	 */
	public static void createAndShow(){
		if (instance == null){
			instance = new MyFrame();
		}
		
		instance.setVisible(true);
	}
}