package metier;

/**
 * 
 * @author OUZEGGANE Redouane
 *	<br/><br/>Cette classe modélise (représente) les équations du premier degré avec un seul inconnu ax + b = 0
 */
public class Equation1D{
	/**
	 * Codification de l'état de l'équation : trois états
	 */
	
	/**
	 * Etat : Solution impossible
	 */
	public static final int ETAT_IMPOSSIBLE 			= 1;
	
	/**
	 * Etat : Infinité de solution
	 */
	public static final int ETAT_INIFINITE_SOLUTION 	= 2;
	
	/**
	 * Etat : Une seule solution
	 */
	public static final int ETAT_UNE_SOLUTION 			= 3;
	

	/**
	 * Les attributs sont toujours inivisbles
	 */
	private float a;
	private float b;
	
	/**
	 * Le premier constructeur par défaut
	 */
	public Equation1D() {
	}
	
	/**
	 * Le deuxième constructeur
	 * @param a
	 * @param b
	 */
	public Equation1D(float a, float b){
		this.a = a;
		this.b = b;
	}

	/*
	 * Les accesseurs et les modificateurs
	 * 
	 */
	
	public float getA() {
		return a;
	}

	public void setA(float a) {
		this.a = a;
	}

	public float getB() {
		return b;
	}

	public void setB(float b) {
		this.b = b;
	}
	
	/**
	 * Obtenir l'état de l'équation (3 états)
	 * @return
	 */
	public int getEtat(){
		if (a != 0) return ETAT_UNE_SOLUTION;
		if (a == 0 && b == 0) return ETAT_INIFINITE_SOLUTION;
		
		return ETAT_IMPOSSIBLE;
	}
	
	
	/**
	 * Obtenir la solution de l'équation (si elle possède une solution)
	 * @return Soit la solution de l'équation (une instance de Float)
	 * Ou bien null (si pas de solution ou inifnité de solution)
	 */
	public Float getSolution(){
		if (getEtat() == ETAT_UNE_SOLUTION){
			return -b / a;
		}
		
		return null;
	}
	
	/**
	 * Obtenir la solution sous forme chaîne de caractère.
	 * @return la solution accompagné de chaîne de caractère pour une meilleure représentation
	 */
	public String getSolutionAsString(){
		String reponse = "Solution de l'équaiton : "+a+"x + "+b+" = 0<br/>";
		int etat = getEtat();
		
		if (etat == ETAT_UNE_SOLUTION){
			reponse += "Il y a une seul solution <font color='blue'>x = "+(-b / a)+"</font>";
		}
		else if (etat == ETAT_INIFINITE_SOLUTION){
			reponse += "Infinité de solution ...";
		}
		else if (etat == ETAT_IMPOSSIBLE){
			reponse += "Soution Impossible";
		}
		
		reponse = "<html><center>"+reponse+"</center></html>";
		return reponse;
	}
	
	
	/**
	 * toString() : une méthode de la classe Object (surcharge de méthode)
	 * @return une chaîne de caractères
	 */
	
	@Override
	public String toString() {
		return "Equation : "+a+"x + "+b+" = 0";
	}
	
}