package userinterface;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;

import metier.Equation1D;

/**
 * 
 * @author OUZEGGANE Redouane
 *<br/><br/>Pour créer une fenêtre Swing, on cree une classe qui herite de JFrame
 *On ajouter apres ce qui est specifique a notre fenetre
 *Comme les trois boutons, une et une seule instanciation (singleton)
 */
public class MyFrame extends JFrame{
	private static final long serialVersionUID = 1L;
	
	private static JFrame instance = null; // l'unique instance a creer (singleton)
	
	private JLabel		lA, lB, lResult;
	private JTextField	tfA, tfB;
	
	private JSeparator	sepResult, sepBottom;
	
	private JButton	bResoudre;
	private JButton	bFermer;
	
	/**
	 * Constructeur private : interdiction d'instancier en dehors de la classe
	 */
	private MyFrame(){
		super("Résolution de l'exquation ax+b = 0");
		initContents();
	}
	
	/**
	 * Pour initialiser le contenu de la fenetre
	 */
	private void initContents(){
		this.lA = new JLabel("La valeur de a : ");
		lB= new JLabel("La valeur de b : ");
		lResult= new JLabel("Pas de Resultat");
		
		lResult.setForeground(Color.RED);
		lResult.setHorizontalAlignment(JLabel.CENTER);
		
		tfA = new JTextField();
		tfB = new JTextField();
		
		sepResult = new JSeparator();
		sepBottom = new JSeparator();
		
		this.bResoudre = new JButton("Résoudre");
		this.bResoudre.setMnemonic('R');
		
		this.bFermer = new JButton("Fermer");
		this.bFermer.setMnemonic('F');
		
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setResizable(false);
		
		manageLyaout();
		manageEvents();
	}
	
	/**
	 * Pour gerer la disposition des composants graphiques (3 boutons) sur le frame
	 */
	private void manageLyaout(){
		this.setLayout(null); // Aucun gestionnaire de disposition : disposition manuelle
		
		lA.setBounds(20, 30, 150, 25);
		tfA.setBounds(180, 30, 150, 25);
		
		lB.setBounds(20, 60, 150, 25);
		tfB.setBounds(180, 60, 150, 25);
		
		sepResult.setBounds(2, 86 ,396,2);
		sepBottom.setBounds(2, 116 ,396,2);
		
		lResult.setBounds(2, 87, 396, 25);
		
		bResoudre.setBounds(20, 120, 170, 25); // setBounds (x, y, width, height)
		bFermer.setBounds(210, 120, 170, 25);
	
		this.add(lA);
		this.add(tfA);
		
		this.add(lB);
		this.add(tfB);
		
		this.add(lResult);
		this.add(sepResult);
		this.add(sepBottom);
		
		this.add(bResoudre);
		this.add(bFermer);
		
		this.setSize(400, 165);
		this.setLocationRelativeTo(null);
	}
	
	/**
	 * Pour programmer les differents evenments
	 */
	private void manageEvents(){
		bResoudre.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				bResourdreActionPerformed(evt);
			}
		});
		
		bFermer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				bFermerActionPerformed(evt);
			}
		});
	}
	
	private void bResourdreActionPerformed(ActionEvent evt){
		if (tfA.getText().trim().equals("")){
			JOptionPane.showMessageDialog(this, "Veuillez introduire la valeur de A");
			return;
		}
		
		if (tfB.getText().trim().equals("")){
			JOptionPane.showMessageDialog(this, "Veuillez introduire la valeur de B");
			return;
		}
		
		float a = 0, b=0;
		
		try{
			a = Float.parseFloat(tfA.getText().trim());
		}
		catch (Exception e){
			e.printStackTrace();
			JOptionPane.showMessageDialog(this, "La valeur de A ne représente pas une valeur numérique");
			return;
		}
		
		try{
			b = Float.parseFloat(tfB.getText().trim());
		}
		catch (Exception e){
			e.printStackTrace();
			JOptionPane.showMessageDialog(this, "La valeur de B ne représente pas une valeur numérique");
			return;
		}
		
		Equation1D e = new Equation1D(a, b);
		lResult.setText(e.getSolutionAsString());
	}
	
	private void bFermerActionPerformed(ActionEvent evt){
		Runtime.getRuntime().exit(0);
	}
	
	/**
	 * permet de creer une instance (si elle n'est pas deja creee) et l'affiche avec setVisible(true)
	 */
	public static void createAndShow(){
		if (instance == null){
			instance = new MyFrame();
		}
		
		instance.setVisible(true);
	}
}