package ui.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.BorderFactory;
import javax.swing.JPanel;

/**
 * 
 * @author OUZEGGANE Redouane
 *<br/><br/>Cette classe représente une zone de dessin
 */
public class DrawingZone extends JPanel{
	private static final long serialVersionUID = 1L;
	
	private RenderingThread  thread = null;
	private Graphics2D buffer;
	private Image image;
	
	public DrawingZone(){
		super();
		initContents();
	}
	
	/**
	 * Pour initialiser le contenu de la fenetre
	 */
	private void initContents(){
		thread = new RenderingThread();
		thread.start();
		
		this.setBorder(BorderFactory.createEtchedBorder());
		
		manageEvents();
	}
	
	/**
	 * Pour programmer les differents evenments
	 */
	private void manageEvents(){
		this.addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent evt){
				thisResized();
			}
		});
	}
	
	private void thisResized(){
		buffer = null;
	}
	
	@Override
	public void paint(Graphics g) {
		if (buffer == null) {
			image = createImage(this.getWidth(), this.getHeight());
			buffer = (Graphics2D) image.getGraphics();
		}

		buffer.setColor(Color.white);
		buffer.fillRect(2, 2, this.getWidth()-4, this.getHeight()-4);
		buffer.setColor(Color.black);
	
		drawElements(buffer);
		
		g.drawImage(image, 0, 0, this);
	}
	
	private void drawElements(Graphics2D buffer){
		buffer.drawString("Ceci un texte dessine", 30, 30);
		
		buffer.setColor(Color.BLUE);
		buffer.setStroke(new BasicStroke(1.0f));
		buffer.drawLine(10, 10, 500, 100);
		
		buffer.setColor(Color.RED);
		buffer.fillRect(100, 100, 100, 100);
		
		buffer.setColor(Color.BLUE);
		buffer.setStroke(new BasicStroke(1.0f));
		buffer.drawRect(100, 100, 100, 100);
		
		buffer.setColor(Color.YELLOW);
		buffer.fillOval(200, 200, 50, 50);
		
		buffer.setColor(Color.GREEN);
		buffer.setStroke(new BasicStroke(1.0f));
		buffer.drawOval(200, 200, 50, 50);
		
		buffer.setColor(Color.RED);
		buffer.fillOval(400, 400, 350, 150);
		buffer.setColor(Color.GREEN);
		buffer.setStroke(new BasicStroke(2.0f));
		buffer.drawOval(400, 400, 350, 150);
	
		Polygon p = new Polygon();
		p.addPoint(500, 100);
		p.addPoint(480, 200);
		p.addPoint(520, 200);
		buffer.setColor(Color.GRAY);
		buffer.fillPolygon(p);
		
		buffer.setColor(Color.BLUE);
		buffer.setStroke(new BasicStroke(1.0f));
		buffer.drawPolygon(p);
	}

	/**
	 * 
	 * @author OUZEGGANE Redouane
	 *Thread pour redissiner la zone chaque periode de : 
	 */
	private class RenderingThread extends Thread{
		public void run(){
			while (true){
				try{
					repaint();
					sleep(33, 00);
				}
				catch (Exception e){
					e.printStackTrace();
				}
			}
		}
	}
}