package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;

import ui.utils.DrawingZone;

/**
 * 
 * @author OUZEGGANE Redouane
 *<br/><br/>Pour créer une fenêtre Swing, on cree une classe qui herite de JFrame
 *On ajouter apres ce qui est specifique a notre fenetre
 *Comme les trois boutons, une et une seule instanciation (singleton)
 */
public class MyFrame extends JFrame{
	private static final long serialVersionUID = 1L;
	
	private static JFrame instance = null; // l'unique instance a creer (singleton)
	
	private JButton			bFermer;
	private JSeparator		sepBottom;
	private DrawingZone		drawingZone;
	
	/**
	 * Constructeur private : interdiction d'instancier en dehors de la classe
	 */
	private MyFrame(){
		super("Java-2D : mon premier example");
		initContents();
	}
	
	/**
	 * Pour initialiser le contenu de la fenetre
	 */
	private void initContents(){
		bFermer = new JButton("Fermer");
		bFermer.setMnemonic('F');
		
		sepBottom = new JSeparator();
		
		drawingZone = new DrawingZone();
		
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		
		manageLyaout();
		manageEvents();
	}
	
	/**
	 * Pour gerer la disposition des composants graphiques (3 boutons) sur le frame
	 */
	private void manageLyaout(){
		GroupLayout layout = new GroupLayout(this.getContentPane());
		this.getContentPane().setLayout(layout);
		layout.setHorizontalGroup(layout.createParallelGroup()
				.addGroup(layout.createSequentialGroup()
					.addGap(10, 10, 10)
					.addComponent(drawingZone, 500, 500, Short.MAX_VALUE)
					.addGap(10, 10, 10)
				)
				.addGroup(layout.createSequentialGroup()
					.addGap(2)
					.addComponent(sepBottom, 800, 800, Short.MAX_VALUE)
					.addGap(2)
				)
				.addGroup(layout.createSequentialGroup()
					.addGap(10, 10, Short.MAX_VALUE)
					.addComponent(bFermer, 150, 150, 150)
					.addGap(10)
				)
		);
		layout.setVerticalGroup(layout.createSequentialGroup()
				.addGap(10, 10, 10)
				.addComponent(drawingZone, 500, 500, Short.MAX_VALUE)
				.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
				.addComponent(sepBottom, 2, 2, 2)
				.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
				.addComponent(bFermer, 25, 25, 25)
				.addGap(10, 10, 10)
		);
		
		this.pack();
		this.setLocationRelativeTo(null);
		this.setMinimumSize(this.getSize());
	}
	
	/**
	 * Pour programmer les differents evenments
	 */
	private void manageEvents(){
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent evt){
				thisClosing();
			}
		});
		
		bFermer.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				thisClosing();
			}
		});
	}
	
	// Le traitement associer a la fermeture de la fenetre et au clique du bouton Fermer
	private void thisClosing(){
		int reponse = JOptionPane.showConfirmDialog(this, "Voulez-vous quitter l'application ?", "Quitter ?", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
		if (reponse == JOptionPane.OK_OPTION){
			Runtime.getRuntime().exit(0);
		}
	}
	
	/**
	 * permet de creer une instance (si elle n'est pas deja creee) et l'affiche avec setVisible(true)
	 */
	public static void createAndShow(){
		if (instance == null){
			instance = new MyFrame();
		}
		
		instance.setVisible(true);
	}
}